<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInvestmentRevaluationItem extends Model 
{

    protected $table = 'acc_investment_revaluation_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'investment_id', 'realized_gain', 'investment_revaluation_id');

    public function investment_revaluation()
    {
        return $this->belongsTo('AccInvestmentRevaluation', 'investment_revaluation_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function investment()
    {
        return $this->belongsTo('AccInvestment', 'investment_id');
    }

}