<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccLockDate extends Model 
{

    protected $table = 'acc_lock_date';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'lock_accounting_period', 'date');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}