<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccNonInventoryItem extends Model 
{

    protected $table = 'acc_non_inventory_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name_ar', 'name_en', 'unit_name_en', 'unit_name_ar', 'sold_balance_sheet_account_id', 'purchased_balance_sheet_account_id', 'sold_profit_loss_account_id', 'purchased_profit_loss_account_id', 'description', 'sales_price', 'purchase_price', 'tax_code_id', 'division_place_id', 'place_id', 'division_id', 'status', 'unit_price');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function sold_balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'sold_balance_sheet_account_id');
    }

    public function purchased_balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'purchased_balance_sheet_account_id');
    }

    public function purchased_profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'purchased_profit_loss_account_id');
    }

    public function sold_profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'sold_profit_loss_account_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function place_id()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

}