<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPayslipDeduction extends Model 
{

    protected $table = 'acc_payslip_deduction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'payslip_id', 'payslip_item_id', 'division_id', 'place_id', 'division_place_id', 'description', 'amount', 'recurring_transaction_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function place_id()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_id()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function payslip_item()
    {
        return $this->belongsTo('AccPayslipItem', 'payslip_item_id');
    }

    public function payslip()
    {
        return $this->belongsTo('AccPayslip', 'payslip_id');
    }

    public function recurring_transaction()
    {
        return $this->belongsTo('AccRecurringTransaction', 'recurring_transaction_id');
    }

}