<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPurchaseInvoice extends Model 
{

    protected $table = 'acc_purchase_invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status', 'user_id', 'footer_id', 'supplier_id', 'date', 'due_type', 'due_date', 'day', 'reference', 'description', 'title', 'sub_total', 'total', 'withholding_tax_type', 'withholding_tax', 'closed_invoice', 'show_item_image', 'show_withholding_tax', 'balance_due', 'days_to_due_date', 'days_overdue', 'sales_quote_id', 'sales_order_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function purchase_quote()
    {
        return $this->belongsTo('AccPurchaseQuote', 'purchase_quote_id');
    }

    public function purchase_order()
    {
        return $this->belongsTo('AccPurchaseOrder', 'purchase_order_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'purchase_invoice_id');
    }

}