<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccPurchaseOrder extends Model 
{

    protected $table = 'acc_purchase_order';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'footer_id', 'supplier_id', 'cancelled', 'purchase_quote_id', 'date', 'reference', 'description', 'quantity_receive', 'amount', 'title', 'status', 'sub_total', 'total', 'withholding_tax_type', 'withholding_tax', 'show_item_image', 'delivery_status', 'invoice_amount', 'invoice_status', 'show_withholding_tax');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function purchase_quote()
    {
        return $this->belongsTo('AccPurchaseQuote', 'purchase_quote_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'purchase_order_id');
    }

}