<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccRecurringCategory extends Model 
{

    protected $table = 'acc_recurring_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}