<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccSupplier extends Model 
{

    protected $table = 'acc_supplier';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'email', 'credit_limit', 'currency_id', 'address', 'division_id', 'division_place_id', 'place_id', 'control_account_id', 'available_credit', 'status', 'account_payable', 'money_status', 'user_id', 'accounts_payable');

    public function currency()
    {
        return $this->belongsTo('AccCurrency', 'currency_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function quotes()
    {
        return $this->hasMany('AccPurchaseQuote', 'supplier_id');
    }

    public function orders()
    {
        return $this->hasMany('AccPurchaseOrder', 'supplier_id');
    }

    public function invoices()
    {
        return $this->hasMany('AccPurchaseInvoice', 'supplier_id');
    }

    public function debit_notes()
    {
        return $this->hasMany('AccDebitNote', 'supplier_id');
    }

    public function goods_receipts()
    {
        return $this->hasMany('AccGoodsReceipt', 'supplier_id');
    }

}