<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccTaxCodeCustom extends Model 
{

    protected $table = 'acc_tax_code_custom';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'rate', 'balance_sheet_account_id', 'user_id', 'tax_code_id', 'amount_reporting_category_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

}