<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCurrencyExchangeTransaction extends Model 
{

    protected $table = 'acc_currency_exchange_transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'base_amount', 'exchange_amount', 'currency_exchange_id', 'user_id');

    public function currency_exchange()
    {
        return $this->belongsTo('AccCurrencyExchange', 'currency_exchange_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}