<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCurrencyRevaluationaItem extends Model 
{

    protected $table = 'acc_currency_revaluation_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'currency_revaluation_id', 'profit_loss_account_id', 'balance_sheet_account_id', 'gain_loss_value', 'control_account_id', 'description', 'special_account_id', 'supplier_id', 'customer_id', 'employee_id', 'bank_account_id', 'capital_account_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function currency_revaluation()
    {
        return $this->belongsTo('AccCurrencyRevaluation', 'currency_revaluation_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function supplier()
    {
        return $this->belongsTo('AccSupplier', 'supplier_id');
    }

    public function capital_account()
    {
        return $this->belongsTo('AccCapitalAccount', 'capital_account_id');
    }

    public function special_account()
    {
        return $this->belongsTo('AccSpecialAccount', 'special_account_id');
    }

}