<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccForecast extends Model 
{

    protected $table = 'acc_forecast';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'repeat', 'growth', 'description', 'amount', 'status');

    public function items()
    {
        return $this->hasMany('AccItem', 'forecast_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}