<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInventoryItem extends Model 
{

    protected $table = 'acc_inventory_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name_en', 'name_ar', 'unit_name_en', 'unit_name_ar', 'division_id', 'place_id', 'divison_place_id', 'control_account_id', 'production_stage', 'quantity_desired', 'receive', 'deliver', 'income_account_id', 'expense_account_id', 'description_en', 'description_ar', 'purchase_price', 'unit_price', 'sales_division_id', 'sales_place_id', 'sales_division_place_id', 'tax_code_id', 'hide_name', 'average_cost', 'total_quantity', 'quantity_on_hand', 'quantity_to_deliver', 'quantity_available', 'quantity_to_receive', 'quantity_be_available', 'quantity_to_order', 'obsolete_quantity_to_receive', 'obsolete_quantity_to_deliver', 'obsolete_quantity_on_hand', 'quantity_owned', 'total_cost', 'user_id', 'status', 'sales_price');

    public function amounts()
    {
        return $this->hasMany('AccInventoryItemAmount', 'inventory_item_id');
    }

    public function inventories()
    {
        return $this->belongsToMany('AccInventory', 'inventory_item_id', 'inventory_id', 'inventory_item_amount_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function income_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'income_account_id');
    }

    public function expense_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'expense_account_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tax_code_id');
    }

    public function sales_division()
    {
        return $this->belongsTo('AccDivision', 'sales_division_id');
    }

    public function sales_division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'sales_division_place_id');
    }

    public function sales_place()
    {
        return $this->belongsTo('AccPlace', 'sales_place_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function inventories()
    {
        return $this->belongsToMany('AccInventory', 'inventory_item_id', 'inventory_id', 'item_store_id');
    }

}