<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccInvestmentRevaluation extends Model 
{

    protected $table = 'acc_investment_revaluation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'date', 'reference', 'description', 'fixed_asset_id', 'realized_gain', 'division_id', 'place_id', 'division_place_id');

    public function items()
    {
        return $this->hasMany('AccInvestmentRevaluationItem', 'investment_revaluation_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function fixed_asset()
    {
        return $this->belongsTo('AccFixedAsset', 'fixed_asset_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

}