<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccReportingCategoryType extends Model 
{

    protected $table = 'acc_reporting_category_type';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name_en', 'name_ar', 'parent_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function types()
    {
        return $this->hasMany('AccReportingCategoryType', 'parent_id');
    }

}