<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccTaxCode extends Model 
{

    protected $table = 'acc_tax_code';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'user_id', 'label', 'tax_rate', 'invoice_title', 'credit_note_title', 'balance_sheet_account_id', 'custome_type', 'rate', 'reverse_charged', 'net_reporting_category_id', 'net_reporting_category_reversed_id', 'amount_reporting_category_reversed_id', 'amount_reporting_category_id', 'status');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function customs()
    {
        return $this->hasMany('AccTaxCodeCustom', 'tax_code_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function net_reporting_category()
    {
        return $this->belongsTo('AccReportingCategory', 'net_reporting_category_id');
    }

    public function net_reporting_category_reversed()
    {
        return $this->belongsTo('AccReportingCategory', 'net_reporting_category_reversed_id');
    }

    public function amount_reporting_category_reversed()
    {
        return $this->belongsTo('AccReportingCategory', 'amount_reporting_category_reversed_id');
    }

    public function amount_reporting_category()
    {
        return $this->belongsTo('AccReportingCategory', 'amount_reporting_category_id');
    }

}