<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('company', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('regcode_id')->unique();
			$table->string('aikods', 255);
			$table->string('company_name', 255);
			$table->string('legal_address', 255);
			$table->string('postal_address', 255);
			$table->boolean('type_pharmacy');
			$table->boolean('type_wholesaler');
			$table->boolean('type_medical_institution');
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('company');
	}
}