<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('lottery_id')->unsigned();
			$table->integer('numticket');
			$table->datetime('date');
			$table->boolean('status');
			$table->boolean('paycheck');
			$table->boolean('wincheck');
			$table->string('winamount');
			$table->float('price');
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}