<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHistoryTable extends Migration {

	public function up()
	{
		Schema::create('history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('notice', 'status'));
			$table->integer('pdf_id')->unsigned();
			$table->integer('status_id')->unsigned();
			$table->integer('comment_id')->unsigned()->nullable();
			$table->boolean('current_status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('history');
	}
}