<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pdf', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('pdf_id')->references('id')->on('pdf')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pdf', function(Blueprint $table) {
			$table->dropForeign('pdf_author_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_pdf_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_status_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_comment_id_foreign');
		});
	}
}