<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nameFirst');
			$table->string('nameLast');
			$table->string('email')->unique();
			$table->string('district_id', 6);
			$table->string('password');
			$table->string('role')->default('applicant');
			$table->tinyInteger('blocked')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}