<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email')->unique();
			$table->string('password');
			$table->integer('user_type_id')->unsigned();
			$table->integer('subscription_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('nickname')->nullable();
			$table->string('phone', 15);
			$table->date('date_of_birth')->nullable();
			$table->enum('gender', array('M', 'F'));
			$table->enum('maritalstatus', array('1', '0'));
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('birth_country_id')->unsigned();
			$table->integer('birth_city_id')->unsigned();
			$table->string('current_place')->nullable();
			$table->string('address')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}