<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgregatFilialeTable extends Migration {

	public function up()
	{
		Schema::create('Agregat_Filiale', function(Blueprint $table) {
			$table->timestamps();
			$table->integer('filiale_id')->unsigned();
			$table->integer('agregat_id')->unsigned();
			$table->integer('valeur_agregat');
			$table->integer('annee');
			$table->enum('mois', array('Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'));
			$table->boolean('valide');
		});
	}

	public function down()
	{
		Schema::drop('Agregat_Filiale');
	}
}