<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilialeProduitTable extends Migration {

	public function up()
	{
		Schema::create('Filiale_Produit', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('filiale_id')->unsigned();
			$table->integer('produit_id')->unsigned();
			$table->float('quant_produite');
			$table->float('quant_vendu');
			$table->float('valeur_quant_vendu');
			$table->float('stock_fin_trim');
			$table->float('capacite_prod');
			$table->integer('annee');
			$table->enum('trimestre', array('1', '2', '3', '4'));
			$table->boolean('valide');
		});
	}

	public function down()
	{
		Schema::drop('Filiale_Produit');
	}
}