<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    public function role()
    {
        return $this->hasOne('Role', 'role_id');
    }

    public function filiale()
    {
        return $this->hasOne('Filiale', 'filiale_id');
    }

    public function rapport()
    {
        return $this->belongsToMany('Rapport')->withPivot('Users_Rapports');
    }

}