<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Charter extends Model 
{

    protected $table = 'charters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'flight_type_id', 'electric_port', 'display', 'best_offer', 'stop_ability', 'flight_instructions', 'pay_later', 'pay_duration', 'void', 'void_duration', 'client_can_cancel', 'cancel_fees', 'from_country_id', 'to_country_id', 'going_date', 'giong_flight_number', 'going_aircraft_id', 'going_from_city_id', 'going_to_city_id', 'going_from_airport_id', 'going_to_airport_id', 'going_airplane_id', 'going_from_lounge', 'going_to_lounge', 'going_departure_time', 'going_arrival_time', 'coming_date', 'coming_flight_number', 'coming_aircraft_id', 'coming_from_city_id', 'coming_to_city_id', 'coming_from_airport_id', 'coming_to_airport_id', 'coming_airplane_id', 'coming_from_lounge', 'coming_to_lounge', 'coming_departure_time', 'coming_arrival_time', 'economy_seats', 'business_seats', 'lock', 'adult_id', 'adult_number', 'children_id', 'children_number', 'baby_id', 'baby_number');

    public function seats()
    {
        return $this->hasMany('CharterSeat', 'charter_id');
    }

    public function prices()
    {
        return $this->hasMany('CharterPrice', 'charter_id');
    }

    public function class_types()
    {
        return $this->hasMany('ClassType', 'charter_id');
    }

    public function flight_type()
    {
        return $this->belongsTo('FlightType', 'flight_type_id');
    }

    public function fr_country()
    {
        return $this->belongsTo('Country', 'from_country_id');
    }

    public function to_country()
    {
        return $this->belongsTo('Country', 'to_country_id');
    }

    public function go_fr_city()
    {
        return $this->belongsTo('City', 'going_from_city_id');
    }

    public function go_to_city()
    {
        return $this->belongsTo('City', 'going_to_city_id');
    }

    public function co_fr_city()
    {
        return $this->belongsTo('City', 'coming_from_city_id');
    }

    public function co_to_city()
    {
        return $this->belongsTo('City', 'coming_to_city_id');
    }

    public function go_aircraft()
    {
        return $this->belongsTo('Aircraft', 'going_aircraft_id');
    }

    public function co_aircraft()
    {
        return $this->belongsTo('Aircraft', 'coming_aircraft_id');
    }

    public function go_airplane()
    {
        return $this->belongsTo('AirplaneType', 'going_airplane_id');
    }

    public function co_airplane()
    {
        return $this->belongsTo('AirplaneType', 'coming_airplane_id');
    }

    public function go_fr_airport()
    {
        return $this->belongsTo('Airport', 'going_from_airport_id');
    }

    public function go_to_airport()
    {
        return $this->belongsTo('Airport', 'going_to_airport_id');
    }

    public function co_fr_airport()
    {
        return $this->belongsTo('Airport', 'coming_from_airport_id');
    }

    public function co_to_airport()
    {
        return $this->belongsTo('Airport', 'coming_to_airport_id');
    }

    public function reserved_seats()
    {
        return $this->hasMany('ReservedSeat', 'charter_id');
    }

    public function adult()
    {
        return $this->belongsTo('Age', 'adult_id');
    }

    public function children()
    {
        return $this->belongsTo('Age', 'children_id');
    }

    public function baby()
    {
        return $this->belongsTo('Age', 'baby_id');
    }

}