<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CharterPrice extends Model 
{

    protected $table = 'charter_prices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('charter_id', 'seat_id', 'flight_type_id', 'age_id', 'price', 'duration_id');

    public function charter()
    {
        return $this->belongsTo('Charter', 'charter_id');
    }

    public function duration()
    {
        return $this->belongsTo('Duration', 'duration_id');
    }

    public function age()
    {
        return $this->belongsTo('Age', 'age_id');
    }

    public function flight_type()
    {
        return $this->belongsTo('FlightType', 'flight_type_id');
    }

    public function seat()
    {
        return $this->belongsTo('CharterSeat', 'seat_id');
    }

}