<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CharterSeat extends Model 
{

    protected $table = 'charter_seats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('charter_id', 'name', 'class_id', 'price_class_id', 'saets', 'available_seats', 'booked_seats');

    public function charter()
    {
        return $this->belongsTo('Charter', 'charter_id');
    }

    public function price_class()
    {
        return $this->belongsTo('PricingClass', 'price_class_id');
    }

    public function class_type()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

    public function prices()
    {
        return $this->hasMany('CharterPrice', 'charter_seat_id');
    }

}