<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChartersClasses extends Model 
{

    protected $table = 'charters_classes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('charter_id', 'class_id');

    public function charter()
    {
        return $this->belongsTo('Charter', 'charter_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

}