<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FlightSeat extends Model 
{

    protected $table = 'flight_seats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('class_id', 'price_class_id', 'seats', 'available_seats', 'booked_seats', 'flight_id');

    public function prices()
    {
        return $this->hasMany('FlightPrice', 'flight_seat_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

    public function price_class()
    {
        return $this->belongsTo('PricingClass', 'price_class_id');
    }

    public function flight()
    {
        return $this->belongsTo('Flight', 'flight_id');
    }

}