<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderCharter extends Model 
{

    protected $table = 'order_charters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'going_charter_id', 'coming_charter_id', 'class_id', 'price_class_id', 'charter_seat_id', 'charter_price_id', 'flight_type_id', 'flight_count');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function go_charter()
    {
        return $this->belongsTo('Charter', 'going_charter_id');
    }

    public function co_charter()
    {
        return $this->belongsTo('Charter', 'coming_charter_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

    public function price_class()
    {
        return $this->belongsTo('PricingClass', 'price_class_id');
    }

    public function seat()
    {
        return $this->belongsTo('CharterSeat', 'charter_seat_id');
    }

    public function price()
    {
        return $this->belongsTo('CharterPrice', 'charter_price_id');
    }

    public function flight_type()
    {
        return $this->belongsTo('FlightType', 'flight_type_id');
    }

}