<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Program extends Model 
{

    protected $table = 'programs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_en', 'title_ar', 'details_en', 'details_ar', 'travel_id');

    public function travel()
    {
        return $this->belongsTo('Travel', 'travel_id');
    }

}