<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Room extends Model 
{

    protected $table = 'rooms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('room_type_id', 'all_rooms', 'available_rooms', 'booked_rooms', 'travel_id');

    public function room_type()
    {
        return $this->belongsTo('RoomType', 'room_type_id');
    }

    public function travel()
    {
        return $this->belongsTo('Travel', 'travel_id');
    }

    public function prices()
    {
        return $this->hasMany('TravelPrice', 'room_id');
    }

}