<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'category_id', 'item_id', 'order_id', 'type', 'direction', 'balance_before', 'amount', 'balance_after', 'comment');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

}