<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Weight extends Model 
{

    protected $table = 'weights';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'item_id', 'class_type_id', 'weight');

    public function category_id()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function class_type()
    {
        return $this->belongsTo('ClassType', 'class_type_id');
    }

}