<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePassengersTable extends Migration {

	public function up()
	{
		Schema::create('passengers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id');
			$table->string('first_name');
			$table->string('last_name');
			$table->enum('title', array('MRS', 'MR', 'INF'));
			$table->enum('status', array('confirmed', 'cancelled', 'temporary', 'noshow', 'used'));
			$table->double('price');
			$table->string('ticket');
			$table->string('ticket_number');
			$table->datetime('birth_date');
			$table->string('birth_place');
			$table->integer('nationality_id');
			$table->string('passport_number');
			$table->datetime('passport_issuance_date');
			$table->datetime('passport_expire_date');
			$table->string('father_name');
			$table->string('mother_name');
			$table->integer('age_id');
		});
	}

	public function down()
	{
		Schema::drop('passengers');
	}
}