<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('category_id');
			$table->integer('item_id');
			$table->integer('order_id');
			$table->enum('type', array('commission', 'fees', 'refund'));
			$table->enum('direction', array('add', 'subtract'));
			$table->double('balance_before');
			$table->double('amount');
			$table->double('balance_after');
			$table->string('comment');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}