<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Airport extends Model 
{

    protected $table = 'airports';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'code', 'country_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}