<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'item_id', 'status', 'user_id', 'phone', 'pnr', 'total_price', 'commission', 'subtotal', 'note');

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}