<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderFlight extends Model 
{

    protected $table = 'order_flights';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'going_flight_id', 'coming_flight_id', 'class_id', 'price_class_id', 'flight_seat_id', 'flight_price_id', 'flight_type_id', 'flight_count');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function go_flight()
    {
        return $this->belongsTo('Flight', 'going_flight_id');
    }

    public function co_flight()
    {
        return $this->belongsTo('Flight', 'coming_flight_id');
    }

    public function class()
    {
        return $this->belongsTo('ClassType', 'class_id');
    }

    public function price_class()
    {
        return $this->belongsTo('PricingClass', 'price_class_id');
    }

    public function seat()
    {
        return $this->belongsTo('FlightSeat', 'flight_seat_id');
    }

    public function price()
    {
        return $this->belongsTo('FlightPrice', 'flight_price_id');
    }

    public function flight_type()
    {
        return $this->belongsTo('FlightType', 'flight_type_id');
    }

}