<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderTravel extends Model 
{

    protected $table = 'order_travels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'travel_id', 'room_type_id', 'room_id', 'travel_price_id');

    public function order()
    {
        return $this->belongsTo('Order', 'order_id');
    }

    public function travel()
    {
        return $this->belongsTo('Travel', 'travel_id');
    }

    public function room_type()
    {
        return $this->belongsTo('RoomType', 'room_type_id');
    }

    public function room()
    {
        return $this->belongsTo('Room', 'room_id');
    }

    public function price()
    {
        return $this->belongsTo('TravelPrice', 'travel_price_id');
    }

}