<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TravelPrice extends Model 
{

    protected $table = 'travel_prices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('age_id', 'room_id', 'price', 'travel_id');

    public function travel()
    {
        return $this->belongsTo('Travel', 'travel_id');
    }

    public function age()
    {
        return $this->belongsTo('Age', 'age_id');
    }

    public function room()
    {
        return $this->belongsTo('Room', 'room_id');
    }

}