<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Visa extends Model 
{

    protected $table = 'visas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'type', 'price', 'papers_en', 'papers_ar', 'best_offer', 'description_en', 'description_ar', 'country_id', 'lock');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}