<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChartersTable extends Migration {

	public function up()
	{
		Schema::create('charters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar');
			$table->integer('flight_type_id');
			$table->enum('electric_port', array('yes', 'no'));
			$table->enum('display', array('yes', 'no'));
			$table->enum('best_offer', array('yes', 'no'));
			$table->enum('stop_ability', array('yes', 'no'));
			$table->string('flight_instructions');
			$table->enum('pay_later', array('yes', 'no'));
			$table->string('pay_duration')->nullable();
			$table->enum('void', array('yes', 'no'));
			$table->string('void_duration')->nullable();
			$table->enum('client_can_cancel', array('yes', 'no'));
			$table->double('cancel_fees')->nullable();
			$table->integer('from_country_id');
			$table->integer('to_country_id');
			$table->datetime('going_date');
			$table->string('giong_flight_number');
			$table->integer('going_aircraft_id');
			$table->integer('going_from_city_id');
			$table->integer('going_to_city_id');
			$table->integer('going_from_airport_id');
			$table->integer('going_to_airport_id');
			$table->integer('going_airplane_id');
			$table->string('going_from_lounge');
			$table->string('going_to_lounge');
			$table->string('going_departure_time');
			$table->string('going_arrival_time');
			$table->datetime('coming_date')->nullable();
			$table->string('coming_flight_number')->nullable();
			$table->integer('coming_aircraft_id');
			$table->integer('coming_from_city_id')->nullable();
			$table->integer('coming_to_city_id')->nullable();
			$table->integer('coming_from_airport_id')->nullable();
			$table->integer('coming_to_airport_id')->nullable();
			$table->integer('coming_airplane_id')->nullable();
			$table->string('coming_from_lounge')->nullable();
			$table->string('coming_to_lounge')->nullable();
			$table->string('coming_departure_time')->nullable();
			$table->string('coming_arrival_time')->nullable();
			$table->integer('economy_seats');
			$table->integer('business_seats');
			$table->boolean('lock')->default(0);
			$table->integer('adult_id')->nullable();
			$table->integer('adult_number')->nullable();
			$table->integer('children_id')->nullable();
			$table->integer('children_number')->nullable();
			$table->integer('baby_id')->nullable();
			$table->integer('baby_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('charters');
	}
}