<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommissionsTable extends Migration {

	public function up()
	{
		Schema::create('commissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id');
			$table->integer('item_id');
			$table->double('value');
			$table->enum('type', array('fixed', 'percentage'));
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('commissions');
	}
}