<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightsTable extends Migration {

	public function up()
	{
		Schema::create('flights', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en');
			$table->string('name_ar');
			$table->integer('flight_type_id');
			$table->enum('electric_port', array('yes', 'no'));
			$table->enum('display', array('yes', 'no'));
			$table->enum('best_offer', array('yes', 'no'));
			$table->enum('stop_ability', array('yes', 'no'));
			$table->enum('cancel_before_departure', array('yes', 'no'));
			$table->double('cancel_before_departure_price')->nullable();
			$table->enum('cancel_after_departure', array('yes', 'no'));
			$table->double('cancel_after_departure_price')->nullable();
			$table->enum('absence', array('yes', 'no'));
			$table->double('absence_price')->nullable();
			$table->enum('change_after_departure', array('yes', 'no'));
			$table->double('change_after_departure_price')->nullable();
			$table->enum('change_before_departure', array('yes', 'no'));
			$table->double('change_before_departure_price')->nullable();
			$table->datetime('going_date');
			$table->string('going_flight_number');
			$table->integer('going_aircraft_id');
			$table->integer('going_from_city_id');
			$table->integer('going_to_city_id');
			$table->integer('going_airplane_id');
			$table->integer('going_from_airport_id');
			$table->integer('going_to_airport_id');
			$table->string('going_from_lounge');
			$table->string('going_to_lounge');
			$table->string('going_departure_time');
			$table->string('going_arrival_time');
			$table->datetime('coming_date')->nullable();
			$table->integer('coming_from_city_id')->nullable();
			$table->integer('coming_to_city_id')->nullable();
			$table->integer('coming_aircraft_id');
			$table->string('coming_flight_number')->nullable();
			$table->integer('coming_airplane_id')->nullable();
			$table->integer('coming_from_airport_id')->nullable();
			$table->integer('coming_to_airport_id')->nullable();
			$table->string('coming_from_lounge')->nullable();
			$table->string('coming_to_lounge')->nullable();
			$table->string('coming_departure_time')->nullable();
			$table->string('coming_arrival_time')->nullable();
			$table->integer('from_country_id');
			$table->integer('to_country_id');
			$table->integer('economy_seats');
			$table->integer('business_seats');
			$table->enum('pay_later', array('yes', 'no'));
			$table->string('pay_duration')->nullable();
			$table->string('flight_instructions')->nullable();
			$table->boolean('lock')->default(0);
			$table->integer('adult_id')->nullable();
			$table->integer('adult_number');
			$table->integer('children_id')->nullable();
			$table->integer('children_number')->nullable();
			$table->integer('baby_id')->nullable();
			$table->integer('baby_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('flights');
	}
}