<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservedSeatsTable extends Migration {

	public function up()
	{
		Schema::create('reserved_seats', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('seat_id');
			$table->integer('charter_id');
			$table->integer('class_id');
			$table->integer('price_class_id')->nullable();
			$table->integer('seats_number');
			$table->string('total_price');
		});
	}

	public function down()
	{
		Schema::drop('reserved_seats');
	}
}