<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderFlightsTable extends Migration {

	public function up()
	{
		Schema::create('order_flights', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id');
			$table->integer('going_flight_id');
			$table->integer('coming_flight_id')->nullable();
			$table->integer('class_id');
			$table->integer('price_class_id')->nullable();
			$table->string('flight_seat_id');
			$table->integer('flight_price_id');
			$table->integer('flight_type_id');
			$table->integer('flight_count');
		});
	}

	public function down()
	{
		Schema::drop('order_flights');
	}
}