<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAbProgramUsersTable extends Migration {

	public function up()
	{
		Schema::create('ab_program_users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('program_id')->unsigned();
			$table->date('start_date')->nullable();
			$table->integer('cheat_day')->unsigned();
			$table->time('wakeup_time')->nullable();
			$table->boolean('active');
			$table->time('preferred_workout_time');
			$table->text('workout_location');
			$table->text('motivation');
			$table->integer('start_weight')->unsigned();
			$table->integer('goal_weight')->unsigned();
			$table->time('cardio_time')->nullable();
			$table->time('workout_time')->nullable();
			$table->time('muscle_time')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ab_program_users');
	}
}