<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_infos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_infos', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->foreign('userInfo_id')->references('id')->on('user_infos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->foreign('membershipType_id')->references('id')->on('membershipTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->foreign('referral_id')->references('id')->on('referrals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Beneficiaries', function(Blueprint $table) {
			$table->foreign('userInfo_id')->references('id')->on('user_infos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Beneficiaries', function(Blueprint $table) {
			$table->foreign('nationality_id')->references('id')->on('nationalities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('volunteers', function(Blueprint $table) {
			$table->foreign('userInfo_id')->references('id')->on('user_infos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('supporter_id')->references('id')->on('Supporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('paymentMethod_id')->references('id')->on('paymentMethods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('supporter_influences', function(Blueprint $table) {
			$table->foreign('supporter_id')->references('id')->on('Supporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('supporter_influences', function(Blueprint $table) {
			$table->foreign('influenceType_id')->references('id')->on('influenceTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('supporter_contributions', function(Blueprint $table) {
			$table->foreign('contributionType_id')->references('id')->on('ContributionTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('supporter_contributions', function(Blueprint $table) {
			$table->foreign('supporter_id')->references('id')->on('Supporters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('volunteer_logs', function(Blueprint $table) {
			$table->foreign('volunteer_id')->references('id')->on('volunteers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beneficiary_services', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('Beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('beneficiary_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('serviceType_id')->references('id')->on('serviceTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('managements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user_infos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('management_id')->references('id')->on('managements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('management_id')->references('id')->on('managements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('Beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Experiences', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('Beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Skills', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('Beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('necessities', function(Blueprint $table) {
			$table->foreign('beneficiary_id')->references('id')->on('Beneficiaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_infos', function(Blueprint $table) {
			$table->dropForeign('user_infos_user_id_foreign');
		});
		Schema::table('user_infos', function(Blueprint $table) {
			$table->dropForeign('user_infos_district_id_foreign');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->dropForeign('Supporters_userInfo_id_foreign');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->dropForeign('Supporters_membershipType_id_foreign');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->dropForeign('Supporters_specialty_id_foreign');
		});
		Schema::table('Supporters', function(Blueprint $table) {
			$table->dropForeign('Supporters_referral_id_foreign');
		});
		Schema::table('Beneficiaries', function(Blueprint $table) {
			$table->dropForeign('Beneficiaries_userInfo_id_foreign');
		});
		Schema::table('Beneficiaries', function(Blueprint $table) {
			$table->dropForeign('Beneficiaries_nationality_id_foreign');
		});
		Schema::table('volunteers', function(Blueprint $table) {
			$table->dropForeign('volunteers_userInfo_id_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_supporter_id_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_paymentMethod_id_foreign');
		});
		Schema::table('supporter_influences', function(Blueprint $table) {
			$table->dropForeign('supporter_influences_supporter_id_foreign');
		});
		Schema::table('supporter_influences', function(Blueprint $table) {
			$table->dropForeign('supporter_influences_influenceType_id_foreign');
		});
		Schema::table('supporter_contributions', function(Blueprint $table) {
			$table->dropForeign('supporter_contributions_contributionType_id_foreign');
		});
		Schema::table('supporter_contributions', function(Blueprint $table) {
			$table->dropForeign('supporter_contributions_supporter_id_foreign');
		});
		Schema::table('volunteer_logs', function(Blueprint $table) {
			$table->dropForeign('volunteer_logs_volunteer_id_foreign');
		});
		Schema::table('beneficiary_services', function(Blueprint $table) {
			$table->dropForeign('beneficiary_services_beneficiary_id_foreign');
		});
		Schema::table('beneficiary_services', function(Blueprint $table) {
			$table->dropForeign('beneficiary_services_service_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_serviceType_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_organization_id_foreign');
		});
		Schema::table('managements', function(Blueprint $table) {
			$table->dropForeign('managements_user_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_management_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_management_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_beneficiary_id_foreign');
		});
		Schema::table('Experiences', function(Blueprint $table) {
			$table->dropForeign('Experiences_beneficiary_id_foreign');
		});
		Schema::table('Skills', function(Blueprint $table) {
			$table->dropForeign('Skills_beneficiary_id_foreign');
		});
		Schema::table('necessities', function(Blueprint $table) {
			$table->dropForeign('necessities_beneficiary_id_foreign');
		});
	}
}